//******************************************
// file			: MQ6822_I2C.c
// version		: V1.0
// brief		: I2C related functions
// note			: I2C related functions are gathered in this subroutine
///******************************************
#include "MQ6822.h"

typedef  unsigned char  uchar ;

void i2c_init();
void start_i2c();
void stop_i2c();
void restart_i2c(void);
extern void  WriteByte(unsigned char data );
unsigned char ReadByte(void);

void Write_Data(uchar addr ,uchar * data, uchar num);	
void read_Data(uchar address,uchar *data,uchar bytes);	
void delay(unsigned int Time);



void i2c_init()		// i2c initialization
{
	P2CR.bit.b3    = 0;
	P2CR.bit.b4    = 0;
	POFFCR1.bit.b4 = 1;		// enable I2C
	while(P2PRD.bit.b3==0||P2PRD.bit.b4==0);//wait for high level

	P2DR.byte      = 0xff;
	P2CR.bit.b3    = 1;
	P2CR.bit.b4    = 1;
	P2FC.bit.b3    = 1;
	P2FC.bit.b4    = 1;
	SBI0CR1.byte   = 0x17 ;
	SBI0CR2.byte   = 0x18;
}


void start_i2c()
{
	while(SBI0SR2.bit.b5==1);	// Confirms that the bus is free
	SBI0CR1.byte = 0x17;		// must
	SBI0CR2.byte = 0xf8;		// Write "1" to SBI0CR2<MST>, <TRX>, <BB> and <PIN> to "1"
}


void restart_i2c()
{
	SBI0CR2.byte = 0x18;
	while(SBI0CR2.bit.b5);		
	while(SBI0CR2.bit.b4==0);	
	SBI0CR2.byte = 0xf8;
}


void stop_i2c()
{
	SBI0CR2.byte=0xD8;			// Sets SBI0CR2<MST>, <TRX> and <PIN> to "1" and SBI0CR2<BB> to "0"
	while(SBI0SR2.bit.b5);		// Waits until the bus is set free
}


//===============================
//write one byte                             
//===============================
unsigned char F_compelet = 0xff;
void  WriteByte( unsigned char data )
{
	SBI0DBR.byte = data;
	while(SBI0SR2.bit.b4);		// wait for requesting interrupt service
	__asm("nop");
	__asm("nop");
	__asm("nop");
}


//===============================
//write bytes of data
//===============================
void Write_Data(uchar addr ,uchar * data, uchar num)
{
	uchar i;
	uchar * p;

	p=data;
	start_i2c();

	WriteByte(0xa0);	// slave address
	WriteByte(addr);	// address to be written data
	for( i=num; i>0; i-- )
	{
		WriteByte(*p);
		p++;
	}
	stop_i2c();
}


// read one byte of data                                
unsigned char ReadByte(void)
{
	unsigned char temp_data;

	SBI0DBR.byte = 0;			// PIN is 1
	while(SBI0SR2.bit.b4);		// wait for requesting interrupt service
	temp_data = SBI0DBR.byte;	// read data

	return temp_data;
}


//===============================
//read bytes of data
//===============================
void read_Data(uchar address,uchar *data,uchar bytes)
{
	uchar i;

	start_i2c();

	WriteByte(0xa0);		//**************************slave address
	WriteByte(address);		// address to be read data
	restart_i2c();
	WriteByte(0xa1);		//**************************read data

	for(i=0;i<bytes;i++,data++ )	
	{
		ReadByte();
		if( i == bytes-2 ) SBI0CR1.byte = 0x07;		// <BCV>=000 <ACK>=0 NACK
		if( i == bytes-1 )
		{	
			SBI0CR1.byte = 0x27 ;	// <BCV>=001 <ACK>=0 NACK
			SBI0DBR.byte = 0xff;	// PIN is 1
			while(SBI0SR2.bit.b4);	// waur for requesting interrupt service
		}
	}
	stop_i2c();
}
